/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import org.python.google.common.base.Objects;
import org.python.google.common.collect.Multiset;
import org.python.google.common.collect.Multisets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
abstract class AbstractMultiset<E>
extends AbstractCollection<E>
implements Multiset<E> {
    private transient Set<E> elementSet;

    AbstractMultiset() {
    }

    @Override
    public abstract Set<Multiset.Entry<E>> entrySet();

    @Override
    public int size() {
        return Multisets.sizeImpl(this);
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return this.count(object) > 0;
    }

    @Override
    public Iterator<E> iterator() {
        return Multisets.iteratorImpl(this);
    }

    @Override
    public int count(Object object) {
        for (Multiset.Entry<E> entry : this.entrySet()) {
            if (!Objects.equal(entry.getElement(), object)) continue;
            return entry.getCount();
        }
        return 0;
    }

    @Override
    public boolean add(@Nullable E e) {
        this.add(e, 1);
        return true;
    }

    @Override
    public int add(E e, int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        return this.remove(object, 1) > 0;
    }

    @Override
    public int remove(Object object, int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int setCount(E e, int n) {
        return Multisets.setCountImpl(this, e, n);
    }

    @Override
    public boolean setCount(E e, int n, int n2) {
        return Multisets.setCountImpl(this, e, n, n2);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return Multisets.addAllImpl(this, collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return Multisets.removeAllImpl(this, collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return Multisets.retainAllImpl(this, collection);
    }

    @Override
    public void clear() {
        this.entrySet().clear();
    }

    @Override
    public Set<E> elementSet() {
        Set<E> set = this.elementSet;
        if (set == null) {
            this.elementSet = set = this.createElementSet();
        }
        return set;
    }

    Set<E> createElementSet() {
        return Multisets.elementSetImpl(this);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return Multisets.equalsImpl(this, object);
    }

    @Override
    public int hashCode() {
        return ((Object)this.entrySet()).hashCode();
    }

    @Override
    public String toString() {
        return this.entrySet().toString();
    }
}

